clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x) x.*exp(-x);  %Gleichung eingeben
obereGrenze         = 3.8;              %b
untereGrenze        = 0.2;              %a
Iterationsschritte  = 6;                %n
sKommastellenDouble = '%.5f';           %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
aWERTETABELLE(1,:)=["i","R(i,0)"];

%BERECHNUNG------------------------------------------------------------------------
aWERTETABELLE(2,1)="0";
aWERTETABELLE(2,2)=num2str(((obereGrenze-untereGrenze)/2)*(Y(untereGrenze)+Y(obereGrenze)),sKommastellenDouble);
for(i=1:1:Iterationsschritte)
    dSCHRITTWEITE=(obereGrenze-untereGrenze)/(2^i);
    Zwischenspeicher=0;
    for(j=1:1:(2^(i-1)))
        Zwischenspeicher=Zwischenspeicher+Y(untereGrenze+(((2*j)-1)*dSCHRITTWEITE));
    end
    aWERTETABELLE(2+i,1)=num2str(i);
    aWERTETABELLE(2+i,2)=num2str((str2double(aWERTETABELLE(1+i,2))/2)+(dSCHRITTWEITE*Zwischenspeicher),sKommastellenDouble);
end
disp(aWERTETABELLE);

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                               %Workspace aufrumen